#ifndef __HCAVM_H
#define __HCAVM_H

#include "stdafx.h"
#include "TraversableAVMGame.h"
#include <fstream>
using std::ofstream;

class HCAVMView {
    enum {NAME_X = 10, NAME_Y = 10, QUESTION_X = 10,
            QUESTION_Y = NAME_Y+20, YESLABEL_X = 50, 
            YESLABEL_Y = QUESTION_Y+20, 
            NOLABEL_X = 120, NOLABEL_Y = YESLABEL_Y,
            YESBOX_X = YESLABEL_X+30, YESBOX_Y = YESLABEL_Y,
            NOBOX_X = NOLABEL_X+30, NOBOX_Y = NOLABEL_Y, 
            BOXWIDTH = 15, BOXHEIGHT = 15};
    enum {
            QUESTIONING, OFFERING_NEW_GAME, GAME_OVER, ASKING_FOR_NEWSUBCATEGORY 
    } state;
    CRect YesBox, NoBox;
    bool inRectangle(CPoint p, CRect r) {
        return p.x >= r.left && p.x <= r.right 
            && p.y >= r.top && p.y <= r.bottom;
    }
    void displayYesNo(CDC *pDC) {
        pDC->TextOut(YESLABEL_X, YESLABEL_Y, _T("Yes"));
        pDC->TextOut(NOLABEL_X, NOLABEL_Y, _T("No"));
        pDC->Rectangle(&YesBox);
        pDC->Rectangle(&NoBox);
    }
    CWnd *pWnd;
    TraversableAVMGame *pGame;
public:
    HCAVMView():YesBox(YESBOX_X, YESBOX_Y, YESBOX_X+BOXWIDTH,
                        YESBOX_Y+BOXHEIGHT),
                NoBox(NOBOX_X, NOBOX_Y, NOBOX_X+BOXWIDTH, 
                        NOBOX_Y+BOXHEIGHT),
                state(QUESTIONING) {}
    void onInitialUpdate(CWnd *pWnd, CDocument *pDoc) {
        pGame = dynamic_cast<TraversableAVMGame*>(pDoc); 
        HCAVMView::pWnd = pWnd;
    }
    void onDraw(CDC *pDC) {
        if (pGame->getName() == "" && !pGame->atEnd()) 
            state = QUESTIONING;
        switch(state) {
        case OFFERING_NEW_GAME:
            pDC->TextOut(NAME_X, NAME_Y, 
                            CString(pGame->getName().c_str()));
            pDC->TextOut(QUESTION_X, QUESTION_Y, 
                            _T("Would you like to play again?"));
            displayYesNo(pDC);
            break;
        case GAME_OVER:
            pDC->TextOut(NAME_X, NAME_Y, _T("Game over")); 
            break;
        case QUESTIONING:
            pDC->TextOut(NAME_X, NAME_Y, 
                            CString(pGame->getName().c_str()));
            pDC->TextOut(QUESTION_X, QUESTION_Y, 
                    CString(pGame->getNextQuestion().c_str()));
            displayYesNo(pDC);
            break;
        case ASKING_FOR_SUBCATEGORY:
            pDC->TextOut(NAME_X, NAME_Y, 
                         CString(pGame->getName().c_str()));
            string question = 
                "Would you like to further specify the type of ";
            question += pGame->getName() += "?";
            pDC->TextOut(QUESTION_X, QUESTION_Y, 
                         CString(question.c_str()));
            displayYesNo(pDC);
            break;
        }
    }
    void onLButtonDown(CPoint p);
    void onFileNew() {
        pGame->initialize();
        pGame->reset();
        CDocument *pDoc = dynamic_cast<CDocument *> (pGame);
        CString pathName = pDoc->GetPathName();
        int i = pathName.GetLength();
        while (i > 0 && pathName[--i] != '\\');
        pathName.Delete(i+1,pathName.GetLength()-i-1);
        pathName.Append(_T("Untitled"));
        ofstream(pathName).close();
        pDoc->SetPathName(pathName);
        pDoc->SetTitle(_T("Untitled"));
        pWnd->Invalidate();
    }
};

CArchive & operator << (CArchive & ar, 
                        TraversableAVMGame & game);
CArchive & operator >> (CArchive & ar, 
                        TraversableAVMGame & game);

    #include "Resource.h"

    class HCNewSubcategoryDialog {
        CStatic* pCategoryLabel;
        CEdit* pSubcategoryName;
        CEdit* pQuestion;
        string subcategoryName, question, categoryName;
    public:
        enum {NAMESIZELIMIT=80, QUESTIONSIZELIMIT=200};
        HCNewSubcategoryDialog(string categoryName)
            :categoryName(categoryName){}
        void onInitDialog(CWnd *pWnd) {
            pCategoryLabel = 
                (CStatic *) (pWnd->GetDlgItem(IDC_CATEGORY_LABEL));
            pSubcategoryName = 
                (CEdit*)(pWnd->GetDlgItem(IDC_EDIT_SUBCATEGORY));
            pQuestion = (CEdit*)(pWnd->GetDlgItem(IDC_EDIT_QUESTION));
            pCategoryLabel->SetWindowText(
                ("Category: " + categoryName).c_str());
        }
        string getSubcategory() { return subcategoryName; }
        string getQuestion() { return question; }
        void onDestroy() {
            char buffer[QUESTIONSIZELIMIT+1];
            pSubcategoryName->GetWindowText(
                (LPTSTR)buffer,NAMESIZELIMIT);
            subcategoryName = buffer;
            pQuestion->GetWindowText(
                (LPTSTR)buffer,QUESTIONSIZELIMIT);
            question = buffer;
        }
    };

#endif
